/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

//var PopupCurrentHidden = null;

function LoadPopup(id, vars, oncomplete , force) {
	STBModulePopups.load(id , vars , oncomplete , force);
}

var STBModulePopups = Object.create(STBModule.prototype);
STBModulePopups.name = "ModulePopups";

STBModulePopups.resize = function() {

	var extraClose	= jQuery('.popup-extra .popup-close'),
        mainClose	= jQuery('.popup .popup-content .main-close');


	if (extraClose.length > 0) {
		mainClose.addClass('removing');
	} else {
		mainClose.removeClass('removing');
	}

	STBModulePopups.resizeClasses();
}

STBModulePopups.resizeClasses = function() {
	var windowWidth		= jQuery(window).width(),
		popup			= jQuery('.popup'),
		windowHeight	= jQuery(window).height(),
		popupExtra		= jQuery('.popup-extra'),
		popupContent	= jQuery('.popup .popup-content'),
        popupContainer	= jQuery('.popup .popup-container');

	if (!popup.length) {
		return false;
	}

	if (!popup.attr("data-class")){
		var pp = popup.attr('class').split(' ')[1];

		popup.attr("data-class", pp);
	}

	if (windowWidth < 992) {
		popup.removeClass(popup.attr("data-class")).addClass('popup-full');
		popup.addClass("popup-mobile");
	} else {
		popupContainer.css("top" , "");
		popup.removeClass('popup-full').addClass(popup.attr("data-class"));
	}

	if (popup.hasClass("popup-center")){
		popupContainer.css("top" , "");

		popupContainer.imagesLoaded(function() {
		
			var popupContainerHeight = popupContainer.outerHeight(),
				restHeight = windowHeight - popupContainerHeight,
				halfRestHeight = restHeight / 2;

			if (popupContainerHeight < windowHeight) {
				popupContainer.css('top', halfRestHeight);
			}		
		});
	}

	var niceOptions = {
		cursorcolor			: "#14acd7",
		cursorwidth			: "0px",
		cursorborder		: "0px solid #14acd7",
		cursorborderradius	: "0px",
		horizrailenabled	: false
	};

	if (popup.hasClass("popup-left") || popup.hasClass("popup-right") || popup.hasClass("popup-top") || popup.hasClass("popup-bottom")) {

		popup.find(".popup-scroll").addClass("nice-scroll").niceScroll(niceOptions);

	} else { 
		if (popup.hasClass("popup-center") || popup.hasClass("popup-full")) {
		  popup.find(".popup-container-inner").addClass("nice-scroll").niceScroll(niceOptions);
		}
	}

	popup.find(".popup-close").removeClass('with-inverted');

	if (popup.hasClass("popup-full")) {
		
		if (popupContent.hasClass("ic")) {
			popup.find(".popup-close").addClass("with-inverted");
		}

		if (popupExtra.length)	{
			popupContent.removeClass('full-height');
		} else {
			popupContent.addClass('full-height');
		}

	} else {
	}
}

STBModulePopups.load = function (id, vars, oncomplete , force) {

    vars = vars || null;
    oncomplete = oncomplete || null;
    force = force || null;

	jQuery(".popup").remove();

    var data = {
        id: id
    };

    if (vars) {
        data['vars'] = vars;
    }

    jQuery.ajax({
        url: "ajax.popup.php?_LANG=" + jQuery("html").attr("lang") + "&f=" + force,
        type: 'post',
        data: jQuery.param(data),
        success: function (msg) {
            if (msg) {

				var body = jQuery("body");

                body.append(msg);

				//process background scheme
				/*
				jQuery(".popup-extra").html(
					STBUtils.bgSchemeReplace(
						jQuery(".popup-extra").html(),
						jQuery(".popup-extra").hasClass("ic") ? "ic" : "nc"
					)
				);

				jQuery(".popup-content").html(
					STBUtils.bgSchemeReplace(
						jQuery(".popup-content").html(),
						jQuery(".popup-content").hasClass("ic") ? "ic" : "nc"
					)
				);
				*/

                if (oncomplete) {
                    oncomplete();
                }

				site.runOnContentUpdate();
				STBModulePopups.resize();

				var popup = jQuery(".popup");

				if (popup.attr("data-close-x") != "1"){
					popup.find(".popup-close").remove();
				}

				if (popup.hasClass("popup-bottom-left") || popup.hasClass("popup-bottom-right") || popup.hasClass("popup-top-left") || popup.hasClass("popup-top-right")) {

				} else {

					if (popup.attr("data-close-outside") == "1"){
						body.addClass("popup-click-out");

						jQuery(document).bind('mouseup touchend', function(e) {

							if (body.hasClass("popup-click-out")) {
								var cont1 = jQuery(".popup-extra-content-inner-inside"),
									cont2 = jQuery(".popup-content");

								// if the target of the click isn't the container nor a descendant of the container
								if ((!cont1.is(e.target) && cont1.has(e.target).length === 0 )) {
									if ((!cont2.is(e.target) && cont2.has(e.target).length === 0 )) {
										STBModulePopups.closeRecord();
										STBUtils.unfreezeBrowser();
										body.removeClass("popup-click-out");

										popup.remove();
									}
								}

								body.removeClass("popup-click-out");
							}


						});
					}

					STBUtils.freezeBrowser();
				}
            }
        }
    });
}



STBModulePopups.showStatic = function(text , style , btn , full) {

	jQuery(".popup").remove();

	var htm = '<div class="popup popup-center popup-forms {ALIGN} active">' + 
			'<div class="popup-overlay"></div>' +
			'<div class="popup-data">';

	if (full) {
		 htm += text ;
	} else {
		 htm +=	'<div class="popup-container ic ">' +
			        '<div class="popup-content container">' +
				        '<div class="generic-text">' + text + '</div>' +
						(btn.length > 0 ? '<a class="btn btn-large popup-close-trigger">'+ btn + '</a>' : "" ) +
			         '</div>' +
		         '</div>';
	}

				
	htm +=	'</div>' +
		'</div>';


     jQuery("body").append(
		 htm
     );

	site.runOnContentUpdate();
	STBModulePopups.resize();
}

STBModulePopups.closeRecord = function() {

	var popup = jQuery(".popup");

   if (popup.attr("data-url-close")) {
		jQuery.ajax({
			url: popup.attr("data-url-close"),
			type: 'post',
			data: 'id=' + popup.attr("data-popup-id")
		});
	}

}

STBModulePopups.close = function() {

        var closeTrigger = function (e) {
            e.preventDefault();
            jQuery(".popup .popup-close").trigger("click");
        };

        var close = function (e) {
            e.preventDefault();

			STBModulePopups.closeRecord();

            jQuery(this).closest(".popup").remove();
			jQuery("body").removeClass("popup-click-out");
			jQuery(document).off("mouseup");

			STBUtils.unfreezeBrowser();
        };

        jQuery(document).on(
            "click",
            ".popup-close-trigger",
            closeTrigger
        );

        jQuery(document).on(
            "click",
            ".popup-close",
            close
        );
}


STBModulePopups.runOnReady = function() {	
	STBModulePopups.close();
}

STBModulePopups.runOnResize = function() {	
	STBModulePopups.resizeClasses();
}

site.registerModule(STBModulePopups);

/* static functions for compatibility */
function ShowPopup(text , style , btn , full)  {
	STBModulePopups.showStatic(text , style , btn , full);
}

function ClickPopup(id) {
	LoadPopup(id , null , null , true);
}

/*future fuctionality*/
function TrackPopupGPlus() {}
function TrackPopupFBLike(url, element) {}
